package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "updateUserEmailAddressValidator")
public class UpdateUserEmailAddressValidator implements Validator {

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String emailAddress = "";
		String reason = "";

		UIInput emailAddressValue = (UIInput) component.getAttributes().get("emailAddress");
		UIInput reasonValue = (UIInput) component.getAttributes().get("reason");

		if (emailAddressValue != null && emailAddressValue.getValue() != null) {
			emailAddress = (String) emailAddressValue.getValue();
		}
		if (reasonValue != null && reasonValue.getValue() != null) {
			reason = (String) reasonValue.getValue();
		}

		// Do email format validation
		boolean isFormatValid = true;
		if (emailAddress != null && !emailAddress.isEmpty()) {
			// This is the same format checker used in the registration page of
			// MHV
			isFormatValid = org.apache.commons.validator.EmailValidator.getInstance().isValid(emailAddress);
		}

		// Check for invalid email and empty reason
		if (!isFormatValid && (reason == null || reason.isEmpty())) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages", FacesContext.getCurrentInstance()
					.getViewRoot().getLocale());
			String errorMessage = bundle.getString("updateEmailAddressInvalid") + "<br/> <li>"
					+ bundle.getString("updateEmailAddressReasonRequired" + "</li>");
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, ""));
		}

		// Check for a reason value
		if (reason == null || reason.isEmpty()) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages", FacesContext.getCurrentInstance()
					.getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("updateEmailAddressReasonRequired"), ""));
		}

		// Handle email format error
		if (!isFormatValid) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages", FacesContext.getCurrentInstance()
					.getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("updateEmailAddressInvalid"), ""));
		}
	}

}
